<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Ayar;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File as FacadesFile;
use Validator;

class AyarController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $ayarlar = Ayar::all();
        return view('admin.ayarlar.index', compact('ayarlar'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return redirect()->route('ayarlar.index')->with('error', 'Ayar eklenemez.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        return redirect()->route('ayarlar.index')->with('error', 'Ayar eklenemez.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $ayar = Ayar::find($id);
        if ($ayar) {
            return view('admin.ayarlar.show', compact('ayar'));
        }
        return redirect()->route('ayarlar.index')->with('error', 'Ayar bulunamadı.');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $ayar = Ayar::find($id);
        if ($ayar) {
            return view('admin.ayarlar.edit', compact('ayar'));
        }
        return redirect()->route('ayarlar.index')->with('error', 'Ayar bulunamadı.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $rule = [
            'value' => 'required',
        ];
        $messages = [
            'key.required' => 'Ayar anahtarı boş bırakılamaz.',
            'value.required' => 'Ayar değeri boş bırakılamaz.',
        ];
        $validator = Validator::make($request->all(), $rule, $messages);
        if ($validator->fails()) {
            return redirect()->route('ayarlar.edit', $id)->with('error', $validator->errors()->first());
        }
        $ayar = Ayar::find($id);
        if ($ayar) {
            if ($request->hasFile('value')) {
                $file = $request->file('value');
                $extension = $file->getClientOriginalExtension();
                $filename = time() . '.' . $extension;
                Storage::disk('public')->putFileAs('uploads', $file, $filename);
                $ayar->value = $filename;
                $ayar->save();
                return redirect()->route('ayarlar.index')->with('success', 'Ayar güncellendi.');
            }else{
                $ayar->value = $request->value;
                $ayar->save();
            }
            return redirect()->route('ayarlar.index')->with('success', 'Ayar güncellendi.');
        }
        return redirect()->route('ayarlar.index')->with('error', 'Ayar bulunamadı.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        return redirect()->route('ayarlar.index')->with('error', 'Ayar silinemez.');
    }
}
