<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AnaMenu;
use App\Models\AltMenu;
use App\Models\Yemek;
use App\Models\Ayar;
use Illuminate\Support\Facades\Http;

class DisariController extends Controller
{
    /*public function __construct(){
        $domain		=	ltrim($_SERVER["HTTP_HOST"],"www.");
        $lic_key 	=	"53d9d6da83faafaf329ba9f15401b6a1";
        $sc_id		=	"18";
        $api_url	=	"https://pyp.com.tr/check?domain=$domain&key=$lic_key&sc_id=$sc_id";
        
        $json = Http::accept('application/json')->get($api_url)->json();
        // dd($json);
        if($json["license"] == "expired"){
            $html = Http::get("https://pyp.com.tr/page/expired")->body();
            die($html);
        }elseif($json["license"] == "trial"){
        	if($json["type"] == "expired"){
        	    $html = Http::get("https://pyp.com.tr/page/expired")->body();
                die($html);
        	}elseif($json["license"] == "valid"){
            	echo 'Geçerli lisans!';
            }else{
                $html = Http::get("https://pyp.com.tr/page/nolicense")->body();
                die($html);
            }
        }elseif($json["license"] == "error"){
            $html = Http::get("https://pyp.com.tr/page/nolicense")->body();
            die($html);
        }
    }   */ 
    
    public function index()
    {

        $menus = AltMenu::join('yemeks', 'alt_menus.id', '=', 'yemeks.alt_menu_id')
            ->select('alt_menus.*')
            ->groupBy('alt_menus.id')
            ->orderBy('alt_menus.sira')
            ->get();
        $ayarlar = Ayar::all();
        return view('front.index', compact('menus', 'ayarlar'));
    }

    public function alt_menu($id)
    {
        $menus = AltMenu::join('yemeks', 'alt_menus.id', '=', 'yemeks.alt_menu_id')
            ->select('alt_menus.*')
            ->groupBy('alt_menus.id')
            ->where('alt_menus.ana_menu_id', $id)
            ->orderBy('alt_menus.sira')
            ->get();
        $ana_menu_check = FALSE;
        if ($menus->count() == 1) {
            $menu = $menus->first();
            return redirect()->route('disari.yemek', ['id' => $menu->id]);
        }
        return view('front.menu', compact('menus', 'ana_menu_check'));
    }

    public function yemek($id)
    {
        $menu_adi = AltMenu::where('id', $id)->first();
        $menus = Yemek::where('alt_menu_id', $id)->orderBy('sira')->get();
        return view('front.yemek', compact('menus', 'menu_adi'));
    }

    public function api_yemekler()
    {
        $data = array();
        $data['data'] = array();
        $menus = AltMenu::join('yemeks', 'alt_menus.id', '=', 'yemeks.alt_menu_id')
            ->select('alt_menus.*')
            ->groupBy('alt_menus.id')
            ->orderBy('alt_menus.sira')
            ->get();
        foreach ($menus as $menu) {
            $yemekler = Yemek::where('alt_menu_id', $menu->id)->orderBy('sira')->get();
            $yemek_data = array();
            foreach ($yemekler as $yemek) {
                $yemek_data[] = array(
                    'id' => $yemek->id,
                    'name' => $yemek->name,
                    'description' => $yemek->kisa_aciklama,
                    'price' => 'Fiyat: ' . $yemek->fiyat,
                    'img' => '/storage/' . $yemek->image
                );
            }
            $data['data'][$menu->name] = $yemek_data;
        }
        $data['success'] = TRUE;
        return response()->json($data, 200);
    }

    public function api_yemek($id)
    {
        $data = array();
        $data['data'] = array();
        $yemek = Yemek::where('id', $id)->first();
        $data['data'] = array(
            'name' => $yemek->name,
            'description' => $yemek->kisa_aciklama,
            'price' => 'Fiyat: ' . $yemek->fiyat,
            'img' => '/storage/' . $yemek->image
        );
        $data['success'] = TRUE;
        return response()->json($data, 200);
    }
}
