@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Ayar Göster')

@section('content')
<div class="row">
    <div class="col-lg-12 col-sm-12">
        <div class="card">
            <div class="card-header">
                <h4>{{ $ayar->key}} Ayarı</h4>
                <br>
                <p>{{ $ayar->description }}</p>
            </div>
            <div class="card-body">
                <form action="{{ route('ayarlar.update', $ayar->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    @if ($ayar->type == 'image')
                    <input type="file" class="form-control" value="{{ $ayar->value }}" name="value">
                    @else
                    <input type="text" class="form-control" value="{{ $ayar->value }}" name="value">
                    @endif
                    <br>
                    <a href="{{ route('ayarlar.index') }}" class="btn btn-primary mt-4">Geri Dön</a>
                    <button type="submit" class="btn btn-success mt-4">Kaydet</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection