@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Yemek Ekle')

@section('vendor-style')
<link rel="stylesheet" href="{{asset('assets/vendor/libs/animate-css/animate.css')}}" />
<link rel="stylesheet" href="{{asset('assets/vendor/libs/sweetalert2/sweetalert2.css')}}" />
@endsection

@section('vendor-script')
<script src="{{asset('assets/vendor/libs/sweetalert2/sweetalert2.js')}}"></script>
<script src="{{asset('assets/vendor/libs/cleavejs/cleave.js')}}"></script>
@if (session('success'))
<script>
    Swal.fire({
        icon: 'success',
        title: 'Başarılı!',
        text: '{{ session('success') }}',
        showConfirmButton: false,
        timer: 1500
    });
</script>

@elseif (session('error'))
<script>
    Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: '{{ session('error') }}',
        showConfirmButton: false,
        timer: 1500
    });
</script>
@endif

@section('content')

<h4>Yeni Yemek Ekle</h4>

<div class="row">
    <div class="col-lg-12 col-sm-12">
        <div class="card">
            <div class="card-body">
                <form action="{{ route('yemek.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="mb-3">
                        <label for="adi" class="form-label">Adı</label>
                        <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="link" class="form-label">Resim</label>
                        <input type="file" class="form-control" id="image" name="image" value="{{ old('image') }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="sira" class="form-label">Sıra</label>
                        <input type="text" class="form-control" id="sira" name="sira" value="{{ old('sira') }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="sira" class="form-label">Hazırlık Süresi</label>
                        <input type="number" class="form-control" id="hazirlik_suresi" name="hazirlik_suresi" value="{{ old('hazirlik_suresi') }}" min="1" step="1" required>
                    </div>
                    <div class="mb-3">
                        <label for="sira" class="form-label">Kısa Açıklama</label>
                        <input type="text" class="form-control" id="kisa_aciklama" name="kisa_aciklama" value="{{ old('kisa_aciklama') }}" min="1" step="1" required>
                    </div>
                    <div class="mb-3">
                        <label for="fiyat" class="form-label">Fiyat</label>
                        <input type="text" class="form-control" id="fiyat" name="fiyat" value="{{ old('fiyat') }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="alt_menu_id" class="form-label">Ana Menü</label>
                        <select name="alt_menu_id" class="form-select" id="inputGroupSelect01">
                            <option value="">Alt Menü Seçiniz</option>
                            @foreach ($alt_menus as $alt_menu)
                            <option value="{{ $alt_menu->id }}">{{ $alt_menu->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection