@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Yemek Göster')

@section('content')
<div class="row">
    <div class="col-lg-12 col-sm-12">
        <div class="card">
            <div class="card-header">
                <h4>{{ $data->name}} Yemeği - Sıra {{ $data->sira }}</h4>
            </div>
            <div class="card-body">
                <img src="{{ asset('storage/' . $data->image) }}" alt="{{ $data->name }}" class="img-fluid">
                <br>
                <div class="mb-3">
                    <label for="adi" class="form-label">Adı</label>
                    <input type="text" class="form-control" id="name" name="name" value="{{ $data->name }}" readonly>
                </div>
                <div class="mb-3">
                    <label for="sira" class="form-label">Sıra</label>
                    <input type="text" class="form-control" id="sira" name="sira" value="{{ $data->sira }}" readonly>
                </div>
                <div class="mb-3">
                    <label for="sira" class="form-label">Hazırlık Süresi</label>
                    <input type="number" class="form-control" id="hazirlik_suresi" name="hazirlik_suresi" value="{{ $data->hazirlik_suresi }}" min="1" step="1" readonly>
                </div>
                <div class="mb-3">
                    <label for="sira" class="form-label">Kısa Açıklama</label>
                    <input type="text" class="form-control" id="kisa_aciklama" name="kisa_aciklama" value="{{ $data->kisa_aciklama }}" min="1" step="1" readonly>
                </div>
                <div class="mb-3">
                    <label for="sira" class="form-label">Fiyat</label>
                    <input type="number" class="form-control" id="fiyat" name="fiyat" value="{{ $data->fiyat }}" min="1" step="0.01" readonly>
                </div>
                <div class="mb-3">
                    <label for="alt_menu_id" class="form-label">Ana Menü</label>
                    <input type="text" class="form-control" id="alt_menu_id" name="alt_menu_id" value="{{ $data->alt_menu_name }}" readonly>
                </div>
                <a href="{{ route('yemek.index') }}" class="btn btn-primary mt-4">Geri Dön</a>
                <a href="{{ route('yemek.edit', $data->id) }}" class="btn btn-warning mt-4">Düzenle</a>
            </div>
        </div>
    </div>
</div>
@endsection