<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Ayarlar'); ?>
<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/animate-css/animate.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/sweetalert2/sweetalert2.css')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<script src="<?php echo e(asset('assets/vendor/libs/sweetalert2/sweetalert2.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/cleavejs/cleave.js')); ?>"></script>
<?php if(session('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Başarılı!',
        text: '<?php echo e(session('success')); ?>',
        showConfirmButton: false,
        timer: 1500
    });
</script>

<?php elseif(session('error')): ?>
<script>
    Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: '<?php echo e(session('error')); ?>',
        showConfirmButton: false,
        timer: 1500
    });
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<h4>Ayarlar</h4>

<div class="row">
    <div class="col-lg-12 col-sm-12">
        <div class="card">
          <div class="table-responsive text-nowrap">
            <table class="table">
              <thead>
                <tr>
                    <th>İsim</th>
                    <th>Açıklama</th>
                    <th>İşlemler</th>
                </tr>
              </thead>
              <tbody class="table-border-bottom-0">
                <?php $__currentLoopData = $ayarlar; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ayar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="w-50"><?php echo e($ayar->key); ?></td>
                    <td><?php echo e($ayar->description); ?></td>
                    <td>
                        <a href="<?php echo e(route('ayarlar.show', $ayar->id)); ?>" class="btn btn-sm btn-outline-primary">Görüntüle</a>
                        <a href="<?php echo e(route('ayarlar.edit', $ayar->id)); ?>" class="btn btn-sm btn-outline-warning">Düzenle</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/baristeksin/web/75simdo.dijimenu.com.tr/public_html/resources/views/admin/ayarlar/index.blade.php ENDPATH**/ ?>